import React from 'react';
import { shallow } from 'enzyme';
import Note from '../Note';


const setup = propOverrides => {
  const props = Object.assign({
      note: {
          id: 'abc',
          text: 'test text'
      }
  }, propOverrides);

  const wrapper = shallow(<Note {...props} />);

  return {
    props,
    wrapper,
  }
}

describe('Notes container Component', () => {
  test('render', () => {
    const { wrapper } = setup()
    expect(wrapper.exists()).toBe(true)
  });

  test('contains note text', () => {
    const { wrapper } = setup();
    expect(wrapper.text()).toBe('test text');
  });

  test('contains note id', () => {
    const { wrapper } = setup();
    expect(wrapper.first().prop('id')).toBe('note-abc');
  });


});