import React from 'react';
import PropTypes from 'prop-types';

const Note = ({note}) => {
  return (
    <div id={"note-" + note.id} className="note">
      <span className="start">{note.startedAt}</span>
      <span className="finish">{note.finishedAt}</span>
      <div dangerouslySetInnerHTML={{ __html: note.html }} />
    </div>
  );
};

Note.propTypes = {
  note: PropTypes.object.isRequired
};

export default Note;
