import React from 'react';
import _ from 'lodash';
import '../App.css';
import './SessionSummary.css'
import {formatTimestamp} from '../utils';

const SessionSummary = ({notes}) => (
  <ul className="list-group sticky-left">
    {notes.map((note) =>
      <li className="list-group-item border-0" key={note.get('_id')}>
          <a href={'#note-' + note.get('_id')}>
            <small className="note-time text-warning bg-success border-0 text-center">{formatTimestamp(note.startedAt)}</small>
            <small className="note-length font-weight-bold px-2 text-muted text-center">{_.words(note.plain).length} mots</small>
            <small className="note-time text-warning bg-success border-0 text-center">{formatTimestamp(note.finishedAt)}</small>
          </a>
      </li>
    )}
  </ul>
)

export default SessionSummary;
