import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Modal from 'react-modal';
import moment from 'moment';
import '../App.css';
import './SessionList.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';
import { getActiveSessions } from '../selectors/coreSelectors';
import { getCurrentUser, getGroups, getCurrentGroup } from '../selectors/authSelectors';

class SessionList extends Component {

  state = {
      show: false,
      modalIsOpen: false,
      sessionToDelete: null,
    }

  componentWillMount() {
    Modal.setAppElement('body');
}

  doSomething(e){
    e.preventDefault();
    console.log(e.target.innerHTML);
  }

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({modalIsOpen: false});
  }

  onClickDelete(session, e) {
    e.preventDefault();
    e.stopPropagation();


    this.setState({
      modalIsOpen: true,
      sessionToDelete: session
    })
  }

  showSessionsNumber = () => {
    if (this.props.sessions.size === 1)
    return (
     <span>{this.props.sessions.size} session</span>
    );
    return (
      <span>{this.props.sessions.size} sessions</span>
     )

  }

  deleteSession = () => {
    const { sessionToDelete } = this.state;

    this.props.sessionsActions.deleteSession(sessionToDelete);

    this.setState({
      modalIsOpen: false,
      sessionToDelete: null
    })
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} group={this.props.currentGroup} />
        <div className="container-fluid">
          <div className="session-count fixed-top bg-secondary font-weight-bold text-danger pl-4 pb-3 mb-3 mt-5 pt-3">
          {this.showSessionsNumber()}
          </div>
          <div className="row mt-4 justify-content-end">
                {this.props.sessions.map((session) =>
                  <div className="session col-lg-5" key={session.get('_id')}>
                      <div className="col-md-auto m-2 p-2">
                        <a className="sessions" onClick={() => this.props.history.push('/sessions/' + session.get('_id'))}>
                          <span className="session-title text-primary">{session.title || 'Session sans titre'}<br /></span>
                          <span className="session-date text-muted">{moment(session.get('date')).format('DD/MM/YYYY')}<br /></span>
                          <span className="session-description">{session.description}<br /></span>
                        </a>
                        <button type="button" id="delete" className="btn btn-link float-left" onClick={ this.onClickDelete.bind(this, session) }>
                          <span className="material-icons delete text-dark">delete</span>
                        </button>
                      </div>
                  </div>
                )}
            </div>
          </div>
        <Modal
        className="Modal__Bootstrap modal-dialog modal-dialog-centered w-25"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div id="delete-session-modal" className="modal-content">
            <span id="delete-session-close-modal-button" className="material-icons text-right" onClick={ this.handleModalCloseRequest }>close</span>
            <div className="modal-body text-center">
            <span className="modal-text">Supprimer cette session ?</span>
              <button type="button" className="btn btn-info text-secondary font-weight-bold py-1 px-2 ml-3" id="delete-session-modal-button" onClick={ this.deleteSession }>Supprimer</button>
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}



function mapStateToProps(state, props) {
  return {
    sessions: getActiveSessions(state),
    currentUser: getCurrentUser(state),
    groups: getGroups(state),
    currentGroup: getCurrentGroup(state)
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionList);
