import React, { Component } from 'react';
import PropTypes from 'prop-types';
import SlateEditor from './SlateEditor';
import { now } from '../utils';


class NoteInput extends Component {

  state = {
    buttonDisabled: false,
    startedAt: null,
    finishedAt: null,
  }

  onEditorChange = (e) => {
    this.setState({
      buttonDisabled: e.value.document === 0,
      startedAt: e.startedAt,
      finishedAt: e.finishedAt
    });
  }

  onAddNoteClick = () => {

    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();
    const html = this.refs.editor.asHtml();
    const categories = this.refs.editor.asCategories();
    // const marginComment = this.marginComment.value;

    this.props.addNote(this.props.session, {
      plain: plain,
      raw: raw,
      html: html,
      startedAt: this.state.startedAt,
      finishedAt: now(),
      categories: categories,
      // marginComment: marginComment,
    });

    this.refs.editor.clear();
    setTimeout(() => this.refs.editor.focus(), 250);
  }

  onCheckboxChange = (e) => {
    this.props.setAutoSubmit(e.target.checked);
  }

  componentDidMount() {
    const text = this.refs.editor.asPlain();
    this.setState({ buttonDisabled: text.length === 0 });
  }

  render() {
    return (
      <form>
        <div className="editor p-3 mb-3">
          <div className="editor-left w-100 border-0 pl-3 pb-3 sticky-bottom">
            <SlateEditor ref="editor"
              onChange={this.onEditorChange}
              onEnterKeyDown={this.onAddNoteClick}
              onButtonClick={this.onAddNoteClick}
              onCheckboxChange={this.onCheckboxChange}
              isChecked={this.props.autoSubmit}
              isButtonDisabled={this.state.buttonDisabled}
              annotationCategories={ this.props.annotationCategories } />

          </div>
          {/* <div className="editor-right w-25 pl-2 border-0 sticky-bottom">
            <input type="textarea" className="form-control h-100"
              name="margin"
              placeholder="Espace de commentaire pour votre note"
              // inputRef={ ref => { this.marginComment = ref; } }
              ref={(marginComment) => { this.marginComment = marginComment; }}
            />
          </div> */}
        </div>
      </form>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
