# Generated by Django 2.0.7 on 2018-07-13 11:05

from django.db import migrations

DEFAULT_METACATEGORIES = [
    {
        'title': 'important',
        'label': 'important',
        'description': 'Utiliser cette métacatégorie lorsque vous estimez que le propos surligné est important dans le traitement du sujet.',
        'color': '#abd9e9', #bleu
        'has_comment': False
    }, {
        'title': 'mot-clef',
        'label': 'mot-clef',
        'description': 'Utiliser cette métacatégorie lorsque vous estimez que le terme surligné est un mot-clef relatif au sujet.',
        'color': '#c2a5cf', #violet
        'has_comment': False
    }, {
        'title': 'commentaire',
        'label': 'commentaire',
        'description': 'Utiliser cette métacatégorie lorsque le propos surligné nécessite un commentaire ou une question.',
        'color': '#abdda4', #vert
        'has_comment': True
    }, {
        'title': 'trouble',
        'label': 'trouble',
        'description': 'Utilisez cette métacatégorie lorsque le propos surligné est à retravailler mais est important à mobiliser dans la suite.',
        'color': '#fdae61', #bleu
        'has_comment': False
    }
]

def create_default_categories(apps, schema_editor):
    Metacategory = apps.get_model("protocols", "Metacategory")
    MetaCategoryRevision = apps.get_model("protocols", "MetacategoryRevision")

    for mc_def in DEFAULT_METACATEGORIES:
        mc = Metacategory.objects.create(app=None, is_default=True, **mc_def)
        MetaCategoryRevision.objects.create(base=mc, **mc_def)

def delete_default_categories(apps, schema_editor):
    Metacategory = apps.get_model("protocols", "Metacategory")
    Metacategory.objects.filter(is_default=True).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('notes', '0001_initial'),
        ('protocols', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_default_categories, delete_default_categories)
    ]
