import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Modal from 'react-modal';
import uuidV1 from 'uuid/v1';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import * as authActions from '../actions/authActions';
// import _ from 'lodash';
import './CreateSession.css';

class CreateSession extends Component {
    state = {
      createGroup: false,
      protocolOpen: false,
      // protocol:null
    }

  componentWillMount() {
    Modal.setAppElement('body');
  }


  openSessionModal = () => {
    this.setState({modalIsOpen: true});
    let groupName = null;
    // let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      // protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          return(
          this.setState({
          protocol: group.get('protocol')
          }))
        }
      }
    }

  }

  createSession = () => {
    const sessionId = uuidV1();
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
        }
      }
    }

    this.props.sessionsActions.createSession(sessionId, groupName, protocol);
    this.props.history.push('/sessions/' + sessionId);
  }

  getGroupProtocol = () => {
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
          return(
            protocol
          );
        }
      }
    }
  }

  // onChange = (e) => {
  //   const { name, value } = e.target;
  //   const changes = { [name]: value }
  //   this.onChangeThrottle(changes);
  // }

  // onChangeThrottle = _.debounce((changes) => {
  //   this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  // }, 750)

  onGroupChange = (e) => {
    const groupName = e.target.value;

    const group = this.props.groups.find((g) => g.get('name') === groupName);

    this.props.sessionsActions.updateSession(this.props.currentSession, { group: groupName, protocol: group?group.get('protocol'):'' });
  }

  componentWillUpdate = (nextProps, nextState) => {
    if (nextState.createGroup && nextProps.createGroup.get('success')) {
      this.setState({ createGroup: false })
    }
  }

  toggleProtocol = () => {
    this.setState({
      protocolOpen: !this.state.protocolOpen,
      show: false

    });
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = (e) => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    e.preventDefault();
    this.setState({modalIsOpen: false});
  }

  render() {

    // if (!this.props.currentSession) {
    //   return (
    //     <form></form>
    //   )
    // }

    return (
      <div>
      <a id="session-button" className="text-center" onClick={this.openSessionModal}>Créer une nouvelle session</a>
      <Modal
      className="Modal__Bootstrap modal-dialog"
      // closeTimeoutMS={150}
      isOpen={this.state.modalIsOpen}
      onRequestClose={this.handleModalCloseRequest}
      >
        <div className="modal-content bg-primary w-75">
          <div className="modal-body">
            <form onSubmit={ e => { e.preventDefault() } }>
            <div className="form-group ml-5 pl-5">
                <label className="col-form-label text-secondary">Groupe</label>
                {/* <p>{this.props.currentSession.group}</p> */}
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary font-weight-bold pt-3">Titre</label>
                <input className="form-control text-primary w-100"
                  name="title"
                  // defaultValue={ this.props.currentSession.title }
                  onChange={ this.onChange }
                  type="text"
                  placeholder="Entrez un titre"
                />
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary font-weight-bold pt-3 mt-3">Description</label>
                <textarea className="form-control text-primary w-100"
                  type="textarea"
                  name="description"
                  // defaultValue={ this.props.currentSession.description }
                  onChange={ this.onChange }
                  placeholder="Entrez une description"
                  row="3"></textarea>
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary font-weight-bold mt-5 ml-5" onClick={this.toggleProtocol}>Protocole de la prise de note {this.state.protocolOpen?<span className="material-icons protocol-toggle">&#xE313;</span>:<span className="material-icons protocol-toggle">&#xE315;</span>}</label>
                <div className={ `collapse ${this.state.protocolOpen?'in':''}`} >
                  {/* <pre>{JSON.stringify(this.props.currentSession.protocol, null, 2)}</pre> */}
                  <pre>{JSON.stringify(this.getGroupProtocol(), null, 2)}</pre>
                </div>
              </div>
              <div className="text-center">
              <button id="create-button" type="submit" className="btn btn-secondary btn-lg text-primary font-weight-bold m-3" onClick={this.createSession}>Commencer</button>
              </div>
            </form>
          </div>
        </div>
      </Modal>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  let group;
  if (props.session && props.session.get('group')) {
    group = state.get('groups').find(group => props.session.get('group') === group.get('name'))
  }

  return {
    currentSession: props.session,
    createGroup: state.get('createGroup'),
    groups: state.get('groups'),
    group
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(CreateSession);
