import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import * as authActions from '../actions/authActions';
import _ from 'lodash';
import './SessionForm.css';

class SessionForm extends Component {

  state = {
    createGroup: false,
    protocolOpen: false
  }

  onChange = (e) => {
    const { name, value } = e.target;
    const changes = { [name]: value }
    this.onChangeThrottle(changes);
  }

  onChangeThrottle = _.debounce((changes) => {
    this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  }, 750)

  onGroupChange = (e) => {
    const groupName = e.target.value;

    const group = this.props.groups.find((g) => g.get('name') === groupName);

    this.props.sessionsActions.updateSession(this.props.currentSession, { group: groupName, protocol: group?group.get('protocol'):'' });
  }

  componentWillUpdate = (nextProps, nextState) => {
    if (nextState.createGroup && nextProps.createGroup.get('success')) {
      this.setState({ createGroup: false })
    }
  }

  toggleProtocol = (e) => {
    e.preventDefault();
    this.setState({
      protocolOpen: !this.state.protocolOpen
    });
  }

  render() {

    if (!this.props.currentSession) {
      return (
        <form></form>
      )
    }

    return (
        <div className="panel-default">
          <div className="card-body">
            <form onSubmit={ e => { e.preventDefault() } }>
              <div className="form-group">
                <label className="col-form-label text-primary">Titre</label>
                <input className="form-control"
                  name="title"
                  defaultValue={ this.props.currentSession.title }
                  onChange={ this.onChange }
                  type="text"
                  placeholder="Entrez un titre"
                />
              </div>
              <div className="form-group">
                <label className="col-form-label text-primary">Description</label>
                <input className="form-control"
                  type="textarea"
                  name="description"
                  defaultValue={ this.props.currentSession.description }
                  onChange={ this.onChange }
                  placeholder="Entrez une description"
                />
              </div>
              <div className="form-group">
                <label className="col-form-label">Group</label>
                <p>{this.props.currentSession.group}</p>
              </div>
              <div className="form-group">
                <label className="col-form-label" onClick={this.toggleProtocol}>Protocol {this.state.protocolOpen?<span className="material-icons protocol-toggle">&#xE313;</span>:<span className="material-icons protocol-toggle">&#xE315;</span>}</label>
                <div className={ `collapse ${this.state.protocolOpen?'in':''}`} >
                  <pre>{JSON.stringify(this.props.currentSession.protocol, null, 2)}</pre>
                </div>
              </div>
            </form>
          </div>
        </div>
    );
  }
}

function mapStateToProps(state, props) {

  let group;
  if (props.session && props.session.get('group')) {
    group = state.get('groups').find(group => props.session.get('group') === group.get('name'))
  }

  return {
    currentSession: props.session,
    createGroup: state.get('createGroup'),
    groups: state.get('groups'),
    group
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionForm);
