import rootReducer from '../reducers';
import rootSaga from '../sagas';
import { loadSessions } from '../actions/sessionsActions';
import { createStore, applyMiddleware, compose } from 'redux';
import { routerMiddleware } from 'react-router-redux';
import handleTransitions from 'redux-history-transitions';
import createSagaMiddleware from 'redux-saga'
import Immutable from 'immutable';
import APIClient from '../APIClient';
import config from '../config';

const token = localStorage.getItem('token');
const currentUser = localStorage.getItem('currentUser');

const defaultState = {
  currentSession: null,
  sessions: Immutable.List([]),
  notes: Immutable.List([]),
  isAuthenticated: token !== null,
  currentUser: currentUser ? JSON.parse(currentUser) : null,
  token: token,
  login: {
    loading: false,
    success: false,
    error: false,
  }
};

const storeInitialState = Immutable.Map(defaultState);

export default (history, initialState = storeInitialState) => {

  const router = routerMiddleware(history);
  const saga = createSagaMiddleware();
  const transitions = handleTransitions(history);

  const store = createStore(rootReducer, initialState, compose(
    applyMiddleware(router, saga),
    transitions
  ));

  const context = {
      client: new APIClient(config.apiRootUrl)
  }

  saga.run(rootSaga, context);

  store.dispatch(loadSessions());

  return store;
};
