import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import NoteInput from './NoteInput';
import NotesList from './NotesList';
import SessionForm from './SessionForm';
import SessionSummary from './SessionSummary';
import * as sessionsActions from '../actions/sessionsActions';
import * as notesActions from '../actions/notesActions';
import * as userActions from '../actions/userActions';
import { getSession, getSessionNotes } from '../selectors/coreSelectors';
import { getAutoSubmit } from '../selectors/authSelectors';
import { extractAnnotationCategories, defaultAnnotationsCategories } from '../constants';

class Session extends Component {
  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <div className="session-container">
          <div className="session-notes">
            <div className="notes-affix">
              <SessionSummary notes={this.props.notes} />
            </div>
            <div className="notes-list">
              <SessionForm session={this.props.currentSession} />
              <hr />
              <NotesList
                notes={this.props.notes}
                deleteNote={this.props.notesActions.deleteNote}
                updateNote={this.props.notesActions.updateNote}
                annotationCategories={this.props.annotationCategories}
              />
            </div>
          </div>
          <section className="editor-fixed">
            <Grid fluid>
              <Row>
                <Col md={9} mdOffset={3}>
                  <NoteInput
                    session={this.props.currentSession}
                    autoSubmit={this.props.autoSubmit}
                    addNote={this.props.notesActions.addNote}
                    setAutoSubmit={this.props.userActions.setAutoSubmit}
                    annotationCategories={this.props.annotationCategories}/>
                </Col>
              </Row>
            </Grid>
          </section>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  const sessionId = props.match.params.id;

  const autoSubmit = getAutoSubmit(state);
  const currentSession = getSession(sessionId, state);
  const currentNotes = getSessionNotes(sessionId, state);
  const annotationCategories = currentSession?extractAnnotationCategories(currentSession.get('protocol')):defaultAnnotationsCategories;

  return {
    currentSession,
    notes: currentNotes,
    autoSubmit,
    annotationCategories
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    notesActions: bindActionCreators(notesActions, dispatch),
    userActions: bindActionCreators(userActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Session);
