import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FormControl } from 'react-bootstrap';
import { formatTimestamp } from '../utils';
import SlateEditor from './SlateEditor';

class Note extends Component {

  onClickDelete = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.onDelete();
  }

  onClickButton = (e) => {

    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();
    const html = this.refs.editor.asHtml();
    const categories = this.refs.editor.asCategories();
    const marginComment = this.marginComment.value;

    const data = {
      plain,
      raw,
      html,
      categories,
      marginComment
    }

    this.props.onSave(this.props.note, data);
  }

  onClickClose = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.onClose();
  }

  renderNoteContent() {
    if (this.props.isEditing) {
      return (
        <div className="note-content">
          <SlateEditor ref="editor"
            onButtonClick={ this.onClickButton }
            note={ this.props.note }
            annotationCategories={ this.props.annotationCategories } />
        </div>
      )
    }

    return (
      <div className="note-content" dangerouslySetInnerHTML={{ __html: this.props.note.html }} />
    )
  }

  renderNoteMarginComment() {
    if (this.props.isEditing) {
      return (
        <div className="note-margin-comment">
          <FormControl
            name="margin"
            componentClass="textarea"
            placeholder="Enter a margin comment for your note"
            defaultValue={ this.props.note.marginComment }
            inputRef={ ref => { this.marginComment = ref; } } />
        </div>
      )
    }

    return (
      <div className="note-margin-comment">
        <small className="text-muted">{ this.props.note.marginComment }</small>
      </div>
    )
  }

  renderNoteRight() {
    if (this.props.isEditing) {
      return (
        <a onClick={this.onClickClose}>
          <span className="material-icons">close</span>
        </a>
      );
    }

    return (
      <a onClick={this.onClickDelete}>
        <span className="material-icons">delete</span>
      </a>
    )
  }

  render() {
    return (
      <div id={"note-" + this.props.note._id} className="note" onClick={ this.props.onClick }>
        <span className="start">{ formatTimestamp(this.props.note.startedAt) }</span>
        <span className="finish">{ formatTimestamp(this.props.note.finishedAt) }</span>
        { this.renderNoteContent() }
        { this.renderNoteMarginComment() }
        { this.renderNoteRight() }
      </div>
    );
  };
}

Note.propTypes = {
  note: PropTypes.object.isRequired,
};

export default Note;
