"""
base abstract models
"""
import uuid

from concurrency.fields import AutoIncVersionField
from django.db import models
from django.utils.translation import ugettext_lazy as _


class ModelManager(models.Manager):
    def get_by_natural_key(self, ext_id):
        return self.get(ext_id=ext_id)

class Model(models.Model):
    objects = ModelManager()

    created = models.DateTimeField(auto_now_add=True, verbose_name=_('Model|created'), db_index=True)
    updated = models.DateTimeField(auto_now=True, verbose_name=_('Model|updated'), db_index=True)
    ext_id = models.UUIDField(unique=True, default=uuid.uuid4, verbose_name=_('Model|ext_id'))
    version = AutoIncVersionField(verbose_name=_('Model|version'))

    def natural_key(self):
        return (self.ext_id, )

    class Meta:
        abstract = True
