import Immutable from 'immutable';
import * as types from '../constants/actionTypes';
import UserRecord from '../store/userRecord';

export const isAuthenticated = (state = false, action) => {
  switch (action.type) {
    case types.AUTH_DEAUTHENTICATE:
    case types.AUTH_LOGOUT:
      return false;
    case types.AUTH_LOGIN_SUCCESS:
      return true;
    default:
      return state;
  }
}

export const currentUser = (state = null, action) => {
  switch (action.type) {
    case types.AUTH_DEAUTHENTICATE:
    case types.AUTH_LOGOUT:
      return null;
    case types.AUTH_LOGIN_SUCCESS:
      return new UserRecord(action.user);
    case types.USER_UPDATE_SETTINGS:
      return state.merge({
        first_name: action.firstname,
        last_name: action.lastname
      });
    default:
      return state;
  }
}

export const token = (state = null, action) => {
  switch (action.type) {
    case types.AUTH_DEAUTHENTICATE:
    case types.AUTH_LOGOUT:
      return null;
    case types.AUTH_STORE_TOKEN:
      return action.token;
    default:
      return state;
  }
}

const loginState = Immutable.Map({
  loading: false,
  success: false,
  error: false,
  errorMessages: Immutable.Map({})
});

export const login = (state = loginState, action) => {
  switch (action.type) {
    case types.AUTH_LOGIN_REQUEST:
      return Immutable.Map({
        loading: true,
        success: false,
        error: false,
      })
    case types.AUTH_LOGIN_SUCCESS:
    case types.AUTH_LOGIN_ERROR:
      return Immutable.Map({
        loading: false,
        success: action.type === types.AUTH_LOGIN_SUCCESS,
        error: action.type === types.AUTH_LOGIN_ERROR,
        errorMessages: action.type === types.AUTH_LOGIN_ERROR ? Immutable.Map(action.error) : Immutable.Map({})
      })
    default:
      return state
  }
}

const registerState = Immutable.Map({
  loading: false,
  success: false,
  error: false,
  errorMessages: Immutable.Map({})
});

export const register = (state = registerState, action) => {
  switch (action.type) {
    case types.AUTH_REGISTER_REQUEST:
      return Immutable.Map({
        loading: true,
        success: false,
        error: false,
      })
    case types.AUTH_LOGIN_SUCCESS:
    case types.AUTH_REGISTER_ERROR:
      return Immutable.Map({
        loading: false,
        success: action.type === types.AUTH_LOGIN_SUCCESS,
        error: action.type === types.AUTH_REGISTER_ERROR,
        errorMessages: action.type === types.AUTH_REGISTER_ERROR ? Immutable.Map(action.error) : Immutable.Map({})
      })
    default:
      return state
  }
}
