"""
Signals for notes app
"""
from django.db.models.signals import post_save
from django.dispatch import receiver
from django.contrib.auth.models import Group
from notes.models import GroupProfile

@receiver(post_save, sender=Group, dispatch_uid="group_created_signal")
def group_saved_callback(sender, instance, **kwargs):
    created = kwargs.pop('created')
    if instance and created:
        profile = GroupProfile(group=instance)
        profile.save()

