import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Modal from 'react-modal';
import moment from 'moment';
import '../App.css';
import './SessionList.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';
import uuidV1 from 'uuid/v1';
import { getActiveSessions } from '../selectors/coreSelectors';
import { getCurrentUser, getGroups, getCurrentGroup } from '../selectors/authSelectors';

class SessionList extends Component {

  constructor(props) {
    super(props);
      this.state = {
      show: false,
      modalIsOpen: false,
      sessionToDelete: null,
    }
    this.doSomething = this.doSomething.bind(this);
    this.toggleShow = this.toggleShow.bind(this);
    this.hide = this.hide.bind(this);
  }

  doSomething(e){
    e.preventDefault();
    console.log(e.target.innerHTML);
  }

  toggleShow(){
    this.setState({show: !this.state.show});
  }

  hide(e){
    if(e && e.relatedTarget){
      e.relatedTarget.click();
    }
    this.setState({show: false});
  }

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({modalIsOpen: false});
  }

  createSession = () => {
    const sessionId = uuidV1();
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
        }
      }
    }

    this.props.sessionsActions.createSession(sessionId, groupName, protocol);
    this.props.history.push('/sessions/' + sessionId);
  }

  onClickDelete(session, e) {
    e.preventDefault();
    e.stopPropagation();


    this.setState({
      modalIsOpen: true,
      sessionToDelete: session
    })
  }

  deleteSession = () => {
    const { sessionToDelete } = this.state;

    this.props.sessionsActions.deleteSession(sessionToDelete);

    this.setState({
      modalIsOpen: false,
      sessionToDelete: null
    })
  }

  render() {
    return (
      <div>
      <button id="session-button" type="button" className="btn btn-primary btn-lg" onClick={this.createSession}>Créer une nouvelle session</button>
        <Navbar history={this.props.history} />
        <div className="top-fade"></div>
        <div className="container-fluid">
          <div className="row">
                {this.props.sessions.map((session) =>
                  <div>
                      <div className="col-md-4 session" key={session.get('_id')}>
                        <a className="sessions" href="#session" onClick={() => this.props.history.push('/sessions/' + session.get('_id'))}>
                          <span className="session-title">{session.title || 'Session sans titre'}<br /></span>
                          <span className="session-date text-muted">{moment(session.get('date')).format('DD/MM/YYYY')}<br /></span>
                          <span className="session-description">{session.description}<br /></span>
                        </a>
                        <button className="btn btn-link pull-left" key={session.get('_id')}  id="toggle-edit" type="button" onClick={this.toggleShow} onBlur={this.hide}>
                          <span className="material-icons edit">edit</span>
                        </button>
                        {
                        this.state.show &&
                          (
                        <button type="button" className="btn btn-link pull-left" style={{display: 'block'}} onClick={ this.onClickDelete.bind(this, session) }>
                        <span className="material-icons delete">delete</span>
                        </button>
                          )
                        }
                      </div>
                  </div>
                )}
            </div>
          </div>
        <Modal
        className="Modal__Bootstrap modal-dialog"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div id="delete-session-modal" className="modal-content text-center">
          <button type="button" id="delete-session-close-modal-button" className="btn btn-default pull-right" onClick={ this.handleModalCloseRequest }><span className="material-icons">close</span></button>
            {/* <div className="modal-body"> */}
            <span className="modal-text">Êtes-vous sûr(e) de vouloir supprimer cette session ?</span>
            {/* </div> */}
            <div className="modal-footer">
              <button type="button" className="btn btn-primary" id="delete-session-modal-button" onClick={ this.deleteSession }>Confirmer</button>
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}



function mapStateToProps(state, props) {
  return {
    sessions: getActiveSessions(state),
    currentUser: getCurrentUser(state),
    groups: getGroups(state),
    currentGroup: getCurrentGroup(state)
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionList);
