import * as types from '../constants/actionTypes';

export const isAuthenticated = (state = false, action) => {
  switch (action.type) {
    default:
      return state;
  }
}

export const currentUser = (state = null, action) => {
  switch (action.type) {
    case types.AUTH_LOGOUT:
      localStorage.removeItem('currentUser');
      return null;
    case types.AUTH_LOGIN_SUCCESS:
      return action.user;
    default:
      return state;
  }
}

export const token = (state = null, action) => {
  switch (action.type) {
    case types.AUTH_LOGOUT:
      localStorage.removeItem('token');
      return null;
    case types.AUTH_STORE_TOKEN:
      return action.token;
    default:
      return state;
  }
}

// TODO Use Immutable.Map
const loginState = {
  loading: false,
  success: false,
  error: false,
}

export const login = (state = loginState, action) => {
  switch (action.type) {
    case types.AUTH_LOGIN_REQUEST:
      return {
        loading: true,
        success: false,
        error: false,
      }
    case types.AUTH_LOGIN_SUCCESS:
    case types.AUTH_LOGIN_ERROR:
      return {
        loading: false,
        success: action.type === types.AUTH_LOGIN_SUCCESS,
        error: action.type === types.AUTH_LOGIN_ERROR,
      }
    default:
      return state
  }
}
