"""
Django settings for irinotes project.

Generated by 'django-admin startproject' using Django 1.11.2.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import datetime
import logging

from corsheaders.defaults import default_headers
from decouple import Csv, config
from dj_database_url import parse as db_url
from unipath import Path

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = Path(__file__).parent

RUN_DIR = BASE_DIR.parent.child('run')

STATIC_ROOT = config('STATIC_ROOT', default=RUN_DIR.child('web').child('static'))
MEDIA_ROOT = config('MEDIA_ROOT', default=RUN_DIR.child('web').child('media'))

# base url
BASE_URL = config('BASE_URL', default='')

# Quick-start development settings - unsuitable for production

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('SECRET_KEY', '@povoyn_1_3dhfjktisno5l_0)_l1+m8$&mr8r2-srvd+m-58d')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = config('DEBUG', default=True, cast=bool)

ALLOWED_HOSTS = config('ALLOWED_HOSTS', default='', cast=Csv())


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'django_extensions',
    'django_filters',
    'irinotes',
    'corsheaders',
    'rest_framework',
    'rest_framework.authtoken',
    'allauth',
    'allauth.account',
    'rest_auth.registration',
    'colorful',
    'concurrency',
    'rest_auth',
    'auditlog',
    'notes',
    'protocols'
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'notes.middlewares.JWTAuthenticationMiddleware',
    'auditlog.middleware.AuditlogMiddleware'
]

ROOT_URLCONF = 'irinotes.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'irinotes.wsgi.application'


# Database
TEST_DATABASE_NAME = config('TEST_DATABASE_NAME', None)

DATABASES = {
    'default': { **config(
        'DATABASE_URL',
        default='sqlite:///' + RUN_DIR.child('db').child('db.sqlite3'),
        cast=db_url
        ),
        **({
            'TEST': {
                'NAME': TEST_DATABASE_NAME
            }
        } if TEST_DATABASE_NAME else {})
    }
}


# Password validation

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

AUTH_USER_MODEL = 'notes.User'


# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = config('STATIC_URL', default=BASE_URL + '/static/')

# Logger

LOG_FILE = config('LOG_FILE', default=RUN_DIR.child('log').child('log.txt'))
LOG_LEVEL = config('LOG_LEVEL', default=logging.DEBUG, cast=lambda l: logging.getLevelName(l))

LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'formatters' : {
        'simple' : {
            'format': "%(asctime)s - %(levelname)s : %(message)s",
        },
        'semi-verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(message)s'
        },
    },
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'stream_to_console': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler'
        },
        'file': {
            'level': LOG_LEVEL,
            'class': 'logging.FileHandler',
            'filename': LOG_FILE,
            'formatter': 'semi-verbose',
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        # 'django.db.backends': {
        #     'handlers': ['file'],
        #     'level': LOG_LEVEL,
        #     'propagate': True,
        # },
        'irinotes': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'notes': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'protocols': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
    }
}

SITE_ID = 1

# Rest Framework configuration

REST_FRAMEWORK = {
    # Use Django's standard `django.contrib.auth` permissions,
    # or allow read-only access for unauthenticated users.
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated'
    ],
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework_jwt.authentication.JSONWebTokenAuthentication',
        'rest_framework.authentication.SessionAuthentication',
        'rest_framework.authentication.BasicAuthentication',
    ),
    'TEST_REQUEST_DEFAULT_FORMAT': 'json',
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 100
}

# Rest auth settings
REST_USE_JWT = True
REST_AUTH_SERIALIZERS = {
    'USER_DETAILS_SERIALIZER': 'notes.api.serializers.auth.UserDetailsSerializer'
}

OLD_PASSWORD_FIELD_ENABLED = True

# JWT settings
JWT_AUTH = {
    'JWT_ALLOW_REFRESH' : True,
    'JWT_EXPIRATION_DELTA' : datetime.timedelta(
        seconds=config('JWT_EXPIRATION_DELTA', 3600, cast=int)
    ),
    'JWT_REFRESH_EXPIRATION_DELTA' : datetime.timedelta(
        seconds=config('JWT_REFRESH_EXPIRATION_DELTA', 3600*24*7, cast=int)
    )
}

# CORS Headers
CORS_ORIGIN_ALLOW_ALL = True
CORS_ALLOW_CREDENTIALS = True

CORS_ALLOW_HEADERS = default_headers + (
    'auditlog-client',
)

CORS_URLS_REGEX = r'^/api/.*$'
