import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Immutable from 'immutable';
import Modal  from 'react-modal';
import Note from './Note';
import './NoteList.css';

class NotesList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      editingNote: null,
      noteToDelete: null,
      modalIsOpen: false,
    }
  }

  componentDidUpdate(prevProps) {
    if ((this.props.notes || []).size > (prevProps.notes || []).size) {
    this.node.scrollIntoView({behavior: "smooth", block: "end", inline: "nearest"})
    }
  }

  // componentDidUpdate(prevProps) {
  //   if (this.props.notes.size > prevProps.notes.size) {
  //   this.node.scrollIntoView({behavior: "smooth", block: "end", inline: "nearest"})
  //   }
  // }

  componentWillMount() {
    Modal.setAppElement('body');
}

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  enterEditMode = (note) => {
    this.setState({ editingNote: note });
  }

  closeNote = () => {
    this.setState({ editingNote: null });
  }

  confirmDelete = (note) => {
    this.setState({
      modalIsOpen: true,
      noteToDelete: note
    })
  }

  deleteNote = () => {
    const { noteToDelete } = this.state;
    this.props.deleteNote(noteToDelete);
    this.closeModal();
  }

  closeModal = () => {
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    })
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    });
  }


  updateNote = (note, data) => {
    this.props.updateNote(note, data);
  }

  render() {
    if (this.props.notes.size === 0) {
      return (
        <div></div>
      );
    }

    return (
      <div>
        <div>
          {this.props.notes.map((note) =>
            <Note
              note={ note }
              key={ note._id}
              onClick={ this.enterEditMode.bind(this, note) }
              onClose={ this.closeNote }
              onDelete={ this.confirmDelete.bind(this, note) }
              onSave={ this.updateNote }
              isEditing={ this.state.editingNote && note === this.state.editingNote }
              annotationCategories={this.props.annotationCategories} />
          )}
            <div className="dummy-div" ref={node => this.node = node}/>
          </div>

        <Modal
        className="Modal__Bootstrap modal-dialog modal-dialog-centered w-25"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div id="delete-note-modal" className="modal-content">
            <span id="delete-note-close-modal-button" className="material-icons text-right" onClick={ this.handleModalCloseRequest }>close</span>
            <div className="modal-body text-center">
            <span className="modal-text">Supprimer cette note ?</span>
              <button type="button" className="btn btn-info text-secondary font-weight-bold py-1 px-2 ml-3" id="delete-note-modal-button" onClick={ this.deleteNote }>Supprimer</button>
            </div>
          </div>
        </Modal>
      </div>
    );
  }
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
