"""
Tests the core models for auth
"""
import logging
from uuid import uuid4

from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
from django.test import TransactionTestCase

logger = logging.getLogger(__name__)


class AuthModelTests(TransactionTestCase):

    def setUp(self):
        User = get_user_model()
        self.user1 = User.objects.create_user(
            username='test_user1',
            email='test_user@emial.com',
            password='top_secret'
        )

        group = Group(name='test_user2 group')
        group.save()

        self.user2 = User.objects.create_user(
            username='test_user2',
            email='test_user@emial.com',
            password='top_secret'
        )
        self.group = Group(name='group1')
        self.group.save()

    def test_create_profile(self):
        self.assertIsNotNone(self.group)
        self.assertIsNotNone(self.group.profile)

    def test_create_personal_group(self):
        self.assertIsNotNone(self.user1.profile)
        self.assertIsNotNone(self.user2.profile)
        default_group1 = self.user1.profile.default_group
        self.assertIsNotNone(default_group1)
        self.assertIsNotNone(default_group1.profile)
        self.assertTrue(default_group1.profile.is_personal)
        self.assertEqual(default_group1.profile.owner, self.user1)
        self.assertEqual(default_group1.profile.owner_personal, self.user1)

    def test_create_personal_group_new_name(self):
        default_group2 = self.user2.profile.default_group
        self.assertIsNotNone(default_group2)
        self.assertEqual(default_group2.name, "test_user2 group 1")

    def test_create_personal_group(self):
        personal_group = Group.objects.get(profile__owner_personal=self.user1)
        self.assertIsNotNone(personal_group)
        self.assertIn(self.user1, personal_group.user_set.all())

