import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import NoteInput from './NoteInput';
import NotesList from './NotesList';
import * as sessionsActions from '../actions/sessionsActions';
import * as notesActions from '../actions/notesActions';

class Session extends Component {

  saveSession = () => {
    const title = this.title.value;
    const description = this.description.value;

    this.props.sessionsActions.updateSession(this.props.currentSession, {
      title: title,
      description: description
    });
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={3}>
              <Panel>
                <form>
                  <FormGroup>
                    <ControlLabel>Title</ControlLabel>
                    <FormControl
                      type="text"
                      defaultValue={this.props.currentSession.title}
                      placeholder="Enter a title for this session"
                      inputRef={ref => { this.title = ref; }}
                    />
                  </FormGroup>
                  <FormGroup>
                    <ControlLabel>Description</ControlLabel>
                    <FormControl
                      componentClass="textarea"
                      defaultValue={this.props.currentSession.description}
                      placeholder="Enter a description for this session"
                      inputRef={ref => { this.description = ref; }}
                    />
                  </FormGroup>
                  <Button bsStyle="primary" onClick={this.saveSession}>Save session</Button>
                </form>
              </Panel>
            </Col>
            <Col md={9}>
              <NotesList notes={this.props.notes} />
              <hr />
              <NoteInput session={this.props.currentSession} addNote={this.props.notesActions.addNote} />
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  const sessionId = props.match.params.id;

  const sessions = state.get('sessions');
  const notes = state.get('notes');

  const currentSession = sessions.find(session => session.id === sessionId);
  const notesBySession = notes.filter(note => note.session === sessionId);

  return {
    currentSession: currentSession,
    sessions: sessions,
    notes: notesBySession
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    notesActions: bindActionCreators(notesActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Session);
