import React, {Component} from 'react';
import { Form, FormGroup, Button, Label, Row, Col } from 'react-bootstrap';
import moment from 'moment';

import PropTypes from 'prop-types';
import SlateEditor from './SlateEditor';
import Clock from './Clock'

class NoteInput extends Component {

  state = {
    buttonDisabled: false,
    startedAt: null,
    finishedAt: null,
  }

  onEditorChange = (e) => {
    this.setState({
      buttonDisabled: e.state.document.length === 0,
      startedAt: e.startedAt,
      finishedAt: e.finishedAt
    });
  }

  onAddNoteClick = () => {
    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();
    const html = this.refs.editor.asHtml();
    const categories = this.refs.editor.asCategories();

    this.props.addNote(this.props.session, {
      plain: plain,
      raw: raw,
      html: html,

      startedAt: this.state.startedAt,
      finishedAt: moment().format('H:mm:ss'),
      categories: categories,
    });

    this.refs.editor.clear();
    setTimeout(() => this.refs.editor.focus(), 250);
  }

  componentDidMount() {
    const text = this.refs.editor.asPlain();
    this.setState({ buttonDisabled: text.length === 0 });
  }

  renderTiming() {
    if (this.state.startedAt && this.state.finishedAt) {
      return (
        <span>
          <Label>{this.state.startedAt}</Label> ⇒ <Label>{this.state.finishedAt}</Label>
        </span>
      )
    } else {
      return (
        <span>No timing</span>
      )
    }
  }

  render() {
    return (
      <Form>
        <Row>
          <Col md={6}>
            { this.renderTiming() }
          </Col>
          <Col md={6} className="text-right">
            <Clock />
          </Col>
        </Row>
        <hr />
        <FormGroup>
          <div className="editor-wrapper">
            <SlateEditor ref="editor" onChange={this.onEditorChange} />
          </div>
        </FormGroup>
        <Button disabled={this.state.buttonDisabled} bsStyle="primary" type="button" onClick={this.onAddNoteClick}>Add Note</Button>
      </Form>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
