import { put, take, all } from 'redux-saga/effects'
import * as types from '../constants/actionTypes';
import { groupCreateSuccess, groupCreateError, groupLoadSucess, groupLoadError } from '../actions/groupActions';
import { updateSession } from '../actions/sessionsActions';

function* watchCreateGroup(context) {
  while (true) {
    const { group } = yield take(types.GROUP_CREATE_ASYNC);
    const client = context.client;
    try {
      const response = yield client.post('/api/auth/group/', group);
      yield put(groupCreateSuccess(response));
    } catch (e) {
      yield put(groupCreateError(e));
    }
  }
}

function* watchCreateGroupAndUpdateSession(context) {
  while (true) {
    const { session, group } = yield take(types.GROUP_CREATE_AND_UPDATE_ASYNC);
    const client = context.client;
    try {
      const response = yield client.post('/api/auth/group/', group);

      const actions = [
        groupCreateSuccess(response),
        updateSession(session, {group: response.name})
      ];
      yield all(actions.map(action => put(action)));

    } catch (e) {
      yield put(groupCreateError(e));
    }
  }
}

function* watchLoadGroups(context) {
  const client = context.client;
  while (true) {
    yield take(types.GROUP_LOAD_ASYNC);
    try {
      const response = yield client.get('/api/auth/group/');
      yield put(groupLoadSucess(response.results));
    } catch (e) {
      yield put(groupLoadError(e));
    }
  }
}

export default function* rootSaga(context) {
  yield all([
    watchCreateGroup(context),
    watchCreateGroupAndUpdateSession(context),
    watchLoadGroups(context),
  ])
}
