import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Panel, FormGroup, ControlLabel, FormControl } from 'react-bootstrap';
import GroupForm from './GroupForm';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import * as authActions from '../actions/authActions';
import _ from 'lodash';

class SessionForm extends Component {

  state = {
    createGroup: false
  }

  onChange = (e) => {
    const { name, value } = e.target;
    const changes = { [name]: value }
    this.onChangeThrottle(changes);
  }

  onChangeThrottle = _.debounce((changes) => {
    this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  }, 750)

  onGroupChange = (e) => {
    const groupName = e.target.value;

    this.props.sessionsActions.updateSession(this.props.currentSession, { group: groupName });
  }

  componentWillUpdate = (nextProps, nextState) => {
    if (nextState.createGroup && nextProps.createGroup.get('success')) {
      this.setState({ createGroup: false })
    }
  }

  render() {

    if (!this.props.currentSession) {
      return (
        <form></form>
      )
    }

    return (
      <Panel>
        <form onSubmit={ e => { e.preventDefault() } }>
          <FormGroup>
            <ControlLabel>Title</ControlLabel>
            <FormControl
              name="title"
              defaultValue={ this.props.currentSession.title }
              onChange={ this.onChange }
              type="text"
              placeholder="Enter a title"
            />
          </FormGroup>
          <FormGroup>
            <ControlLabel>Description</ControlLabel>
            <FormControl
              name="description"
              componentClass="textarea"
              defaultValue={ this.props.currentSession.description }
              onChange={ this.onChange }
              placeholder="Enter a description"
            />
          </FormGroup>
          <FormGroup>
            <ControlLabel>Group</ControlLabel>
            <FormControl
              name="group"
              componentClass="select"
              value={ this.props.group ? this.props.group.get('name') : '' }
              onChange={ this.onGroupChange }>
              { this.props.groups.map((group, key) =>
                <option key={ key } value={ group.get('name') }>{ group.get('name') }</option>
              ) }
            </FormControl>
          </FormGroup>
          <FormGroup>
            <GroupForm session={this.props.session} />
          </FormGroup>
        </form>
      </Panel>
    );
  }
}

function mapStateToProps(state, props) {

  let group;
  if (props.session && props.session.get('group')) {
    group = state.get('groups').find(group => props.session.get('group') === group.get('name'))
  }

  return {
    currentSession: props.session,
    createGroup: state.get('createGroup'),
    groups: state.get('groups'),
    group
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionForm);
