import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router';
import { bindActionCreators } from 'redux';
// import logo from './logo.svg';
import { Navbar, Nav, NavItem, NavDropdown, MenuItem, Modal, Button } from 'react-bootstrap';
import * as authActions from '../actions/authActions';

const LoginNav = ({isAuthenticated, currentUser, history, authActions, onLogout}) => {

  const onClickSettings = (e) => {
    e.preventDefault();
    history.push('/settings');
  }

  const onClickLogin = (e) => {
    e.preventDefault();
    history.push('/login');
  }

  if (isAuthenticated) {
    return (
      <NavDropdown title={ currentUser.get('username') } id="user-dropdown">
        <MenuItem onClick={onClickSettings}>Settings</MenuItem>
        <MenuItem onClick={onLogout}>Logout</MenuItem>
      </NavDropdown>
    );
  }
  return (
    <NavItem onClick={onClickLogin} href="/login">Login</NavItem>
  );
}

const Online = ({ offline }) => {
  return (
    <NavItem>
      <span className="material-icons" style={{ color: offline.online ? '#2ECC71' : '#E74C3C' }}>signal_wifi_4_bar</span>
    </NavItem>
  )
}

class AppNavbar extends Component {

  state = {
    showModal: false
  }

  closeModal = () => {
    this.setState({ showModal: false });
  }

  onClickHome = (e) => {
    e.preventDefault();
    this.props.history.push('/');
  }

  isOutboxEmpty = () => {
    return this.props.offline.outbox.length === 0;
  }

  onClickLogout = (e) => {
    e.preventDefault();
    const isOutboxEmpty = this.isOutboxEmpty();
    if (isOutboxEmpty) {
      this.logout();
    } else {
      this.setState({ showModal: true })
    }
  }

  confirmLogout = () => {
    const isOutboxEmpty = this.isOutboxEmpty();
    if (!isOutboxEmpty) {
      this.props.authActions.purgeOutbox();
    }
    this.logout();
    this.closeModal();
  }

  logout = () => {
    this.props.authActions.logout();
    this.props.history.push('/');
  }

  onClickSessions = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }

  render() {
    return (
      <Navbar fluid inverse fixedTop>
        <Navbar.Header>
          <Navbar.Brand>
            <a onClick={this.onClickHome} href="/">IRI Notes</a>
          </Navbar.Brand>
          <Navbar.Toggle />
        </Navbar.Header>
        <Navbar.Collapse>
          <Nav>
            <NavItem onClick={this.onClickSessions} href="/sessions">Sessions</NavItem>
          </Nav>
          <Nav pullRight>
            <Online {...this.props} />
            <LoginNav {...this.props} onLogout={this.onClickLogout} />
          </Nav>
        </Navbar.Collapse>
        <Modal show={this.state.showModal} onHide={this.closeModal}>
          <Modal.Body>
            <p className="text-center">
              Some data is not synchronized with server.
              <br />
              If you continue, it will be lost.
            </p>
          </Modal.Body>
          <Modal.Footer>
            <Button bsStyle="primary" onClick={this.confirmLogout}>Confirm</Button>
            <Button onClick={this.closeModal}>Close</Button>
          </Modal.Footer>
        </Modal>
      </Navbar>
    );
  }
}

AppNavbar.propTypes = {
  isAuthenticated: PropTypes.bool.isRequired
};

function mapStateToProps(state, props) {
  return {
    isAuthenticated: state['isAuthenticated'],
    currentUser: state['currentUser'],
    offline: state['offline']
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(withRouter(AppNavbar));
