import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';
import { getOnline, getCreateGroup } from '../selectors/authSelectors';

class CreateGroup extends Component {

  state = {
    name: '',
    description: ''
  }

  createGroup = () => {

    const { name, description } = this.state;

    if(name && name.trim() !== "") {
      this.props.authActions.createGroup(name, description);
    }
  }

  submit = (e) => {
    e.preventDefault();

    this.createGroup();
  }

  handleInputChange = (e) => {
    const target = e.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && fieldname in errorMessages) {
      return errorMessages[fieldname].map((message, key) =>
        <p className="help-block" key={ key }>{ message }</p>
      );
    }
  }

  renderNonFieldErrors(errorMessages) {
    if (errorMessages && 'non_field_errors' in errorMessages) {
      const errors = errorMessages['non_field_errors'];
      return (
        <div class="alert alert-danger" role="alert">
        { errors.map((message, key) =>
          <p key={ key }>{ message }</p>
        ) }
        </div>
      )
    }
  }

  cancel = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }


  render() {

    const errorMessages = this.props.createGroup.getIn(['errorMessages', 'data']);
    const okDisabled = (!this.state.name || this.state.name.trim() === "");

    return (
      <div>
        <Navbar history={this.props.history} />
        <div className="container-fluid">
            <div className="row">
              <div className="col-md-6 col-md-offset-3">
                <div className="panel-login panel panel-default">
                  <div className="panel-heading">
                  <h4 className="text-uppercase text-center">New Group</h4>
                  <form onSubmit={this.submit}>
                    <div className="form-group" validationState={ errorMessages && ('name' in errorMessages) ? 'error' : null }>
                      <label className="control-label">Nom</label>
                      <input className="form-control" type="text" onChange={this.handleInputChange} name="name" placeholder="Group name..."/>
                      { this.renderErrorMessage(errorMessages, 'name') }
                    </div>
                    <div className="form-group" validationState={ errorMessages && ('description' in errorMessages) ? 'error' : null }>
                      <label className="control-label">Password</label>
                      <input className="form-control" type="textarea" onChange={this.handleInputChange} name="description" placeholder="Description..."/>
                      { this.renderErrorMessage(errorMessages, 'description') }
                    </div>
                    { this.renderNonFieldErrors(errorMessages) }
                    <div className="row">
                    <div className="col-md-6"><button type="submit" className="btn btn-primary btn-lg btn-block" disabled={okDisabled}>Ok</button></div>
                    <div className="col-md-6"><button type="button" className="btn btn-default btn-lg btn-block" onClick={this.cancel}>Annuler</button></div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    createGroup: getCreateGroup(state),
    online: getOnline(state),
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(CreateGroup);
