import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Immutable from 'immutable';
import { Modal } from 'react-bootstrap';
import Note from './Note';

class NotesList extends Component {

  state = {
    editingNote: null,
    noteToDelete: null,
    showModal: false,
  }

  enterEditMode = (note) => {
    this.setState({ editingNote: note });
  }

  closeNote = () => {
    this.setState({ editingNote: null });
  }

  confirmDelete = (note) => {
    this.setState({
      showModal: true,
      noteToDelete: note
    })
  }

  deleteNote = () => {
    const { noteToDelete } = this.state;
    this.props.deleteNote(noteToDelete);
    this.closeModal();
  }

  closeModal = () => {
    this.setState({
      showModal: false,
      noteToDelete: null
    })
  }

  updateNote = (note, data) => {
    this.props.updateNote(note, data);
  }

  render() {
    if (this.props.notes.size === 0) {
      return (
        <div className="alert alert-warning">Commencez votre première note en écrivant dans le champ texte ci-dessous</div>
      );
    }

    return (
      <div>

        {this.props.notes.map((note) =>
          <Note
            note={ note }
            key={ note._id }
            onClick={ this.enterEditMode.bind(this, note) }
            onClose={ this.closeNote }
            onDelete={ this.confirmDelete.bind(this, note) }
            onSave={ this.updateNote }
            isEditing={ this.state.editingNote && note === this.state.editingNote }
            annotationCategories={this.props.annotationCategories} />
        )}

        <Modal show={this.state.showModal} onHide={this.closeModal}>
          <Modal.Body>
            Êtes vous sûr(e) ?
          </Modal.Body>
          <Modal.Footer>
            <button type="submit" className="btn btn-primary btn-lg" onClick={ this.deleteNote }>Confirm</button>
            <button type="submit" className="btn btn-default btn-lg" onClick={ this.closeModal }>Close</button>
          </Modal.Footer>
        </Modal>

      </div>
    );
  }
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
