import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import './Login.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Login extends Component {

  state = {
    username: '',
    password: ''
  }

  handleInputChange = (e) => {
    const target = e.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }


  login = () => {
    const { username, password } = this.state;

    this.props.authActions.loginSubmit(username, password);
  }

  submit = (e) => {
    e.preventDefault();

    this.login();
  }

  onClickRegister = (e) => {
    e.preventDefault();
    this.props.history.push('/register');
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && errorMessages.has(fieldname)) {
      return errorMessages.get(fieldname).map((message, key) =>
        <p className="help-block" key={ key }>{ message }</p>
      );
    }
  }

  renderNonFieldErrors(errorMessages) {
    if (errorMessages && errorMessages.has('non_field_errors')) {
      const errors = errorMessages.get('non_field_errors');
      return (
        <div class="alert alert-danger" role="alert">
        { errors.map((message, key) =>
          <p key={ key }>{ message }</p>
        ) }
        </div>
      )
    }
  }

  render() {

    const errorMessages = this.props.login.get('errorMessages');

    return (
      <div>
        <Navbar history={this.props.history} />
        <div className="container-fluid">
          <div className="row">
            <div className="col-md-6 col-md-offset-3">
              <div className="panel-login panel panel-default">
                <div className="panel-heading">
                  <h4 className="text-center panel-title">IRI Notes</h4>
                  <form onSubmit={this.submit}>
                    <div className="form-group" validationState={ errorMessages && errorMessages.has('username') ? 'error' : null }>
                      <label className="control-label">Nom d'utilisateur</label>
                      <input className="form-control" type="text" onChange={this.handleInputChange} name="username" />
                      { this.renderErrorMessage(errorMessages, 'username') }
                    </div>
                    <div className="form-group" validationState={ errorMessages && errorMessages.has('password') ? 'error' : null }>
                      <label className="control-label">Mot de passe</label>
                      <input className="form-control" type="password" onChange={this.handleInputChange} name="password" />
                      { this.renderErrorMessage(errorMessages, 'password') }
                    </div>
                    { this.renderNonFieldErrors(errorMessages) }
                    <button type="submit" className="btn btn-primary btn-lg">Se connecter</button>
                  </form>
                </div>
              </div>
              <p className="text-center">
                <a className="text-muted" href="/register" onClick={ this.onClickRegister }>Pas encore inscrit ? Créer un compte.</a>
              </p>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    login: state.get('login')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Login);
