import React from 'react';
import _ from 'lodash';
import '../App.css';
import {formatTimestamp} from '../utils';

const SessionSummary = ({notes}) => (
  <ul className="list-group">
    {notes.map((note) =>
      <li className="list-group-item" key={note.get('_id')}>
        <a href={'#note-' + note.get('_id')}>
          <span className="text-muted">{formatTimestamp(note.startedAt)} → {formatTimestamp(note.finishedAt)}</span>
          <span className="pull-right">{_.words(note.plain).length} words</span>
        </a>
      </li>
    )}
  </ul>
)

export default SessionSummary;
