import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import Navbar from './Navbar';
import * as userActions from '../actions/userActions';

class Settings extends Component {

  updateSettings = () => {
    const username = this.props.currentUser.username;
    const firstname = this.firstname.value;
    const lastname = this.lastname.value;

    this.props.userActions.updateSettings(username, firstname, lastname);
  }

  render() {

    const firstname = this.props.currentUser ? this.props.currentUser.first_name : '';
    const lastname = this.props.currentUser ? this.props.currentUser.last_name : '';

    return (
      <div>
        <Navbar history={this.props.history} />
        <div className="container-fluid">
          <div className="row">
            <div className="col-md-6 col-md-offset-3">
              <form>
                <div className="form-group">
                  <label className="control-label">Prénom</label>
                  <input className="form-control"
                    name="firstname"
                    defaultValue={ firstname }
                    placeholder="Entrez un prénom"
                    ref={(firstname) => { this.firstname = firstname; }}
                  />
                </div>
                <div className="form-group">
                  <label className="control-label">Nom</label>
                  <input className="form-control"
                    name="lastname"
                    defaultValue={ lastname }
                    placeholder="Entrez un nom"
                    ref={(lastname) => { this.lastname = lastname; }}
                  />
                </div>
              </form>
              <button type="submit" className="btn btn-primary btn-lg" onClick={this.updateSettings}>Enregistrer</button>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentUser: state.getIn(['authStatus', 'currentUser']),
  };
}

function mapDispatchToProps(dispatch) {
  return {
    userActions: bindActionCreators(userActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Settings);
