"""
Permissions for auth objects
"""
import logging

from rest_framework import permissions
from rest_framework.permissions import BasePermission
from rest_framework.compat import is_authenticated

logger = logging.getLogger(__name__)


class GroupPermission(BasePermission):
    """
    Pemissions for Groups objects
    """

    def has_permission(self, request, view):
        return request.user and is_authenticated(request.user)


    def has_object_permission(self, request, view, obj):
        if request.method not in permissions.SAFE_METHODS:
            return request.user == obj.profile.owner
        return True
