import React, {Component} from 'react';

import ReactDOM from 'react-dom'
import { Form, FormControl, FormGroup, Button } from 'react-bootstrap';

import PropTypes from 'prop-types';

class NoteInput extends Component {
  constructor(props) {
    super(props);

    this.state = {value: ''};

    this.onAddNoteClick = this.onAddNoteClick.bind(this);
    this.handleChange = this.handleChange.bind(this);
  }

  handleChange(event) {
    this.setState({value : event.target.value});
  }

  onAddNoteClick(event) {
    this.props.addNote(this.state.value);

    this.noteInput.value = "";

    this.noteInput.focus();
  }

  componentDidMount() {
    this.noteInput.focus();
  }

  render() {
    return (
      <Form>
        <FormGroup>
          <FormControl
              componentClass="textarea"
              placeholder="Enter note"
              onChange={this.handleChange}
              ref={(input) => { this.noteInput = ReactDOM.findDOMNode(input); }}
          />
        </FormGroup>
        <Button type="button" onClick={this.onAddNoteClick}>Add Note</Button>
      </Form>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
