import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, ListGroup, ListGroupItem, Button } from 'react-bootstrap';
import moment from 'moment';
import '../App.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';

class Sessions extends Component {

  createNewSession = () => {
    const result = this.props.actions.createNewSession();
    // FIXME Feels ugly, change location after state has changed?
    this.props.history.push('/sessions/' + result.session.id)
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <ListGroup>
                {this.props.sessions.map((session) =>
                  <ListGroupItem
                    key={session.id}
                    onClick={() => this.props.history.push('/sessions/' + session.id)}>
                    {session.title || 'No title'} {session.id} {moment(session.date).format('DD/MM/YYYY')}
                  </ListGroupItem>
                )}
              </ListGroup>
              <Button bsStyle="success" onClick={this.createNewSession}>Create new session</Button>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentSession: state.get('currentSession'),
    sessions: state.get('sessions')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    actions: bindActionCreators(sessionsActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Sessions);
