import React from 'react';
import PropTypes from 'prop-types';

const Note = ({note}) => {
  return (
    <div id={"note-" + note.id}>
      <h5>{note.startedAt} ⇒ {note.finishedAt}</h5>
      <div dangerouslySetInnerHTML={{ __html: note.html }} />
    </div>
  );
};

Note.propTypes = {
  note: PropTypes.object.isRequired
};

export default Note;
