from django.conf.urls import url, include
from rest_framework_nested import routers
from .views import SessionViewSet, NoteViewSet

router = routers.SimpleRouter()
router.register(r'sessions', SessionViewSet, base_name='session')

session_router = routers.NestedSimpleRouter(router, r'sessions', lookup='session')
session_router.register(r'notes', NoteViewSet, base_name='notes')

# Wire up our API using automatic URL routing.
# Additionally, we include login URLs for the browsable API.
urlpatterns = [
    url(r'^', include(router.urls)),
    url(r'^', include(session_router.urls)),
]
