// cf http://redux.js.org/docs/recipes/WritingTests.html

import Immutable from 'immutable';

import uuidV1 from 'uuid/v1';

import reducer from '../notesReducer'
import * as types from '../../constants/ActionTypes'
import noteRecord from '../../store/noteRecord';

describe('note reducer', () => {
  it('should return the initial state', () => {
    expect(
      reducer(undefined, {})
    ).toEqual(Immutable.List([]))
  });

  it('should handle ADD_NOTE', () => {

    const newId = uuidV1();
    expect(
      reducer(Immutable.List([]), {
        type: types.ADD_NOTE,
        note: {
          id: newId,
          text: 'Run the tests'
        }
      })
    ).toEqual(
      Immutable.List([
        new noteRecord({
          id: newId,
          text: 'Run the tests',
        })
      ])
    );

    const initialStore = Immutable.List([
        new noteRecord({
          id: uuidV1(),
          text: 'origial note',
        })
    ]);
    expect(
      reducer(initialStore, {
        type: types.ADD_NOTE,
        note: {
          id: newId,
          text: 'Run the tests'
        }
      })
    ).toEqual(
      initialStore.push(
        new noteRecord({
          id: newId,
          text: 'Run the tests',
        })
      )
    );

  });



});

//     expect(
//       reducer(
//         [
//           {
//             text: 'Use Redux',
//             completed: false,
//             id: 0
//           }
//         ],
//         {
//           type: types.ADD_TODO,
//           text: 'Run the tests'
//         }
//       )
//     ).toEqual(
//       [
//         {
//           text: 'Run the tests',
//           completed: false,
//           id: 1
//         },
//         {
//           text: 'Use Redux',
//           completed: false,
//           id: 0
//         }
//       ]
//     )
