import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import './Login.css';
// import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Login extends Component {

  state = {
    username: '',
    password: ''
  }

  handleInputChange = (e) => {
    const target = e.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }


  login = () => {
    const { username, password } = this.state;

    this.props.authActions.loginSubmit(username, password);
  }

  submit = (e) => {
    e.preventDefault();
    this.login();
  }

  onClickRegister = (e) => {
    e.preventDefault();
    this.props.history.push('/register');
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && errorMessages.has(fieldname)) {
      return errorMessages.get(fieldname).map((message, key) =>
        <p className="form-text" key={ key }>{ message }</p>
      );
    }
  }

  renderNonFieldErrors(errorMessages) {
    if (errorMessages && errorMessages.has('non_field_errors')) {
      const errors = errorMessages.get('non_field_errors');
      return (
        <div class="alert alert-danger" role="alert">
        { errors.map((message, key) =>
          <p key={ key }>{ message }</p>
        ) }
        </div>
      )
    }
  }

  render() {

    // const errorMessages = this.props.login.get('errorMessages');

    return (
      <div>
        {/* <Navbar history={this.props.history} /> */}
        <div className="container-fluid">
          <div className="row">
            <div className="col-lg-6 offset-md-3">
              <div className="panel-login panel panel-default">
                <div className="card-header bg-secondary border-0 mt-5 pt-5">
                  <h4 className="text-center card-title font-weight-bold text-lg">IRI Notes</h4>
                  <form className="pt-3 ml-5 pl-5" onSubmit={this.submit}>
                    <div className="form-group mb-2 ml-3 w-75" /*validationState={ errorMessages && errorMessages.has('username') ? 'error' : null }*/>
                      <label className="col-form-label text-primary font-weight-bold mt-2">Nom d'utilisateur</label>
                      <input className="form-control bg-danger border-0 text-muted" type="text" onChange={this.handleInputChange} name="username" />
                      {/* { this.renderErrorMessage(errorMessages, 'username') } */}
                    </div>
                    <div className="form-group mb-2 ml-3 w-75" /*validationState={ errorMessages && errorMessages.has('password') ? 'error' : null*/ >
                      <label className="col-form-label text-primary font-weight-bold mt-2">Mot de passe</label>
                      <input className="form-control bg-danger border-0 text-muted" type="password" onChange={this.handleInputChange} name="password" />
                      {/* { this.renderErrorMessage(errorMessages, 'password') } */}
                    </div>
                    {/* { this.renderNonFieldErrors(errorMessages) } */}
                    <div className="text-center mr-5 pr-5">
                    <button type="submit" className="btn btn-primary btn-lg text-secondary font-weight-bold mt-3">Se connecter</button>
                    </div>
                  </form>
                </div>
              </div>
              <p className="text-center">
                <a className="text-muted" href="/register" onClick={ this.onClickRegister }>Pas encore inscrit ? Créer un compte.</a>
              </p>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    login: state.get('login')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Login);
