"""
irinotes core module
"""
from auditlog.registry import auditlog
from django.conf import settings
from django.db import models
from django.utils import timezone
from django.utils.translation import ugettext_lazy as _

from .base import Model


class Session(Model):
    """
    Class modeling a Session
    """
    class Meta:
        verbose_name = _('Session')
        verbose_name_plural = _('Sessions')

    date = models.DateTimeField(default=timezone.now, verbose_name=_('Session|date'))

    owner = models.ForeignKey(
        settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
    )
    title = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Session|title')
    )
    description = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Session|description')
    )
    protocol = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Session|protocol')
    )

    def get_additional_data(self):
        return {'ext_id': str(self.ext_id)}

    def __str__(self):
        return self.title


class Note(Model):
    """
    Class nodeling a Note
    """
    class Meta:
        verbose_name = _('Note')
        verbose_name_plural = _('Notes')
        ordering = ["tc_start"]

    def get_additional_data(self):
        return {'ext_id': str(self.ext_id)}

    tc_start = models.DateTimeField(verbose_name=_('Note|tc_start'))
    tc_end = models.DateTimeField(verbose_name=_('Note|tc_end'))
    session = models.ForeignKey(
        Session,
        on_delete=models.CASCADE,
        related_name='notes',
        verbose_name=_('Note|session')
    )
    plain = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Note|plain')
    )
    html = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Note|html')
    )
    raw = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Note|raw')
    )
    margin_note = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Note|margin_note')
    )
    categorization = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Note|categorization')
    )
auditlog.register(Session)
auditlog.register(Note)
