import Immutable from 'immutable';
import * as types from '../constants/actionTypes';
import SessionRecord from '../store/sessionRecord';
import { ActionEnum } from '../constants';

export const sessions = (state = Immutable.List([]), action) => {

  switch (action.type) {

    case types.CREATE_SESSION: {
      return state.push(new SessionRecord(action.session));
    }
    case types.UPDATE_SESSION: {
      const sessionToUpdate = state.find(session => session === action.session);
      const sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      let newAction;
      switch (sessionToUpdate.get('action')) {
        case ActionEnum.CREATED:
          newAction = ActionEnum.CREATED;
          break;
        case ActionEnum.DELETED: // should not happen, but...
          newAction = ActionEnum.DELETED;
          break;
        default:
          newAction = ActionEnum.UPDATED;
      }

      const updatedSession = sessionToUpdate.merge(action.values, {action: newAction});
      return state.set(sessionIndex, updatedSession);
    }
    case types.DO_DELETE_SESSION: {
      return state.filter((session) => action.sessionId !== session._id)
    }
    case types.DELETE_SESSION: {
      const sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      const deletedSession = state.get(sessionIndex);
      if(deletedSession.get('action') === ActionEnum.CREATED) {
        // The session was previously created, we can delete it
        return state.delete(sessionIndex);
      } else {
        return state.set(sessionIndex, deletedSession.merge({action: ActionEnum.DELETED}));
      }
    }
    case types.LOAD_SESSIONS: {
      return action.sessions;
    }
    case types.LOAD_SESSION: {
      const sessionRec = action.session;
      const sessionId = sessionRec.get('_id');
      const index = state.findIndex((session) => session.get('_id') === sessionId);
      if(index >= 0) {
        return state.set(index, sessionRec);
      } else {
        return state.push(sessionRec);
      }
    }
    case types.SYNC_RESET_ALL: {
      return state.map((session) => {
        if(session.action !== ActionEnum.NONE) {
          return session.merge({action: ActionEnum.None});
        } else {
          return session;
        }
      });
    }
    case types.RESET_ACTION_SESSION: {
      const sessionId = action.session.get('_id');
      const index = state.findIndex((session) => session.get('_id') === sessionId);
      const session = state.get(index);
      return state.set(index, session.merge({action: ActionEnum.NONE}));
    }
    default:
      return state;
  }
};
