import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import PropTypes from 'prop-types';
import { formatTimestamp } from '../utils';
import SlateEditor from './SlateEditor';
import * as notesActions from '../actions/notesActions';

class Note extends Component {

  state = {
    edit: false
  }

  toggleEditMode = () => {
    const { edit } = this.state;
    this.setState({ edit: !edit })
  }

  onClickDelete = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.notesActions.deleteNote(this.props.note);
  }

  renderNoteContent() {
    if (this.state.edit) {
      return (
        <div className="note-content">
          <SlateEditor ref="editor"
            onChange={this.onEditorChange}
            onEnterKeyDown={this.onAddNoteClick}
            onButtonClick={this.onAddNoteClick}
            onCheckboxChange={this.onCheckboxChange}
            isChecked={this.props.autoSubmit}
            isButtonDisabled={this.state.buttonDisabled}
            withButtons={false}
            note={this.props.note} />
        </div>
      )
    }

    return (
      <div className="note-content" dangerouslySetInnerHTML={{ __html: this.props.note.html }} />
    )
  }

  render() {
    return (
      <div id={"note-" + this.props.note._id} className="note" onClick={ this.toggleEditMode }>
        <span className="start">{ formatTimestamp(this.props.note.startedAt) }</span>
        <span className="finish">{ formatTimestamp(this.props.note.finishedAt) }</span>
        { this.renderNoteContent() }
        <div className="note-margin-comment">
          <small className="text-muted">{ this.props.note.marginComment }</small>
        </div>
        <a onClick={this.onClickDelete}>
          <span className="material-icons">delete</span>
        </a>
      </div>
    );
  };
}

Note.propTypes = {
  note: PropTypes.object.isRequired
};

function mapStateToProps(state, props) {
  return props;
}

function mapDispatchToProps(dispatch) {
  return {
    notesActions: bindActionCreators(notesActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Note);
