import Immutable from 'immutable';
import * as types from '../constants/actionTypes';
import NoteRecord from '../store/noteRecord';

export default (state = Immutable.List([]), action) => {
  switch (action.type) {
    case types.ADD_NOTE:
      return state.push(new NoteRecord(action.note));
    case types.DELETE_NOTE:
      const noteIndex = state.findIndex((note) => note.get('_id') === action.note.get('_id'));
      return state.delete(noteIndex);
    default:
      return state;
  }
};
