import { put, take, all } from 'redux-saga/effects'
import * as types from '../constants/actionTypes';

function* watchCreateGroup(context) {
  while (true) {
    const { group } = yield take(types.GROUP_CREATE_ASYNC);
    const client = context.client;
    try {
      const response = yield client.post('/api/auth/group/', group);
      yield put({ type: types.GROUP_CREATE_SUCCESS, group: response });
    } catch (e) {
      yield put({ type: types.GROUP_CREATE_ERROR, error: e });
    }
  }
}

export default function* rootSaga(context) {
  yield all([
    watchCreateGroup(context),
  ])
}
