import React from 'react';
import { shallow } from 'enzyme';
import NotesContainer from '../NotesContainer';
import {createStore} from 'redux';
import Immutable from 'immutable';

const initialState = Immutable.Map({
    notes: Immutable.List([])
});


const setup = propOverrides => {
  const props = Object.assign({
    store: createStore((state) => { return state; }, initialState)
  }, propOverrides);

  const wrapper = shallow(<NotesContainer {...props} />).dive();

  return {
    props,
    wrapper,
  }
}

describe('Notes container Component', () => {
  test('render', () => {
    const { wrapper } = setup()
    expect(wrapper.exists()).toBe(true)
  });

  test('contains notes list', () => {
    const { wrapper } = setup();
    expect(wrapper.find('NotesList').exists()).toBe(true);
  });

  test('contains note input', () => {
    const { wrapper } = setup();
    expect(wrapper.find('NoteInput').exists()).toBe(true);
  });
});
