import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import NoteInput from './NoteInput';
import NotesList from './NotesList';
import SessionForm from './SessionForm';
import SessionSummary from './SessionSummary';
import * as sessionsActions from '../actions/sessionsActions';
import * as notesActions from '../actions/notesActions';
import * as userActions from '../actions/userActions';
import { ActionEnum } from '../constants';

class Session extends Component {
  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <div className="session-container">
          <div className="session-notes">
            <div className="notes-affix">
              <SessionSummary notes={this.props.notes} />
            </div>
            <div className="notes-list">
              <SessionForm session={this.props.currentSession} />
              <hr />
              <NotesList
                notes={this.props.notes}
                deleteNote={this.props.notesActions.deleteNote}
                updateNote={this.props.notesActions.updateNote}
              />
            </div>
          </div>
          <section className="editor-fixed">
            <Grid fluid>
              <Row>
                <Col md={9} mdOffset={3}>
                  <NoteInput
                    session={this.props.currentSession}
                    autoSubmit={this.props.autoSubmit}
                    addNote={this.props.notesActions.addNote}
                    setAutoSubmit={this.props.userActions.setAutoSubmit} />
                </Col>
              </Row>
            </Grid>
          </section>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  const sessionId = props.match.params.id;

  const sessions = state.get('sessions');
  const notes = state.get('notes');
  const autoSubmit = state.get('autoSubmit');

  const currentSession = sessions.find(session => session._id === sessionId);
  const currentNotes = notes.filter(note => {
        return (note.get('session') === sessionId && note.get('action') !== ActionEnum.DELETED);
    }).sortBy( n => n.get('startedAt') );

  return {
    currentSession,
    sessions,
    notes: currentNotes,
    autoSubmit
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    notesActions: bindActionCreators(notesActions, dispatch),
    userActions: bindActionCreators(userActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Session);
