VERSION = (0, 2, 2, 'final', 0)
VERSION_STR = ".".join(map(lambda i:"%02d" % (i,), VERSION[:2]))

###
# https://github.com/django/django/blob/1.9.1/django/utils/version.py
#
def get_version(version=None):
    "Returns a PEP 440-compliant version number from VERSION."
    if not version:
        version = VERSION
    version = get_complete_version(version)

    # Now build the two parts of the version number:
    # main = X.Y[.Z]
    # sub = .devN - for pre-alpha releases
    #     | {a|b|rc}N - for alpha, beta, and rc releases

    main = get_main_version(version)

    sub = ''
    if version[3] == 'alpha' and version[4] == 0:
        sub = '.dev'

    elif version[3] != 'final':
        mapping = {'alpha': 'a', 'beta': 'b', 'rc': 'rc'}
        sub = mapping[version[3]] + str(version[4])

    return str(main + sub)

def get_complete_version(version):
    """
    then checks for correctness of the tuple provided.
    """
    assert len(version) == 5
    assert version[3] in ('alpha', 'beta', 'rc', 'final')

    return version

def get_main_version(version=None):
    "Returns main version (X.Y[.Z]) from VERSION."
    version = get_complete_version(version)
    parts = 2 if version[2] == 0 else 3
    return '.'.join(str(x) for x in version[:parts])

__version__ = get_version(VERSION)

default_app_config = 'irinotes.apps.IriNotesConfig'
