// cf. http://redux.js.org/docs/recipes/WritingTests.html

import * as actions from '../notesActions'
import * as types from '../../constants/actionTypes'

describe('actions', () => {

  it('should create an action to add a note', () => {
    const text = 'test note'
    const session = { id: 'abcd123' }
    const expectedAction = {
      type: types.ADD_NOTE,
      note: {
        id: expect.stringMatching(/[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}/),
        session: session.id,
        text: text
      }
    }

    const receivedAction = actions.addNote(session, text);
    expect(receivedAction).toMatchObject(expectedAction);

  })
})
