import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';

class Login extends Component {

  login = () => {
    const username = this.username.value;
    const password = this.password.value;

    console.log(username, password);

  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <Panel>
                <form>
                  <FormGroup>
                    <ControlLabel>Username</ControlLabel>
                    <FormControl componentClass="input" type="text" inputRef={ref => { this.username = ref; }} />
                  </FormGroup>
                  <FormGroup>
                    <ControlLabel>Password</ControlLabel>
                    <FormControl componentClass="input" type="password" inputRef={ref => { this.password = ref; }} />
                  </FormGroup>
                  <Button block bsStyle="primary" onClick={this.login}>Login</Button>
                </form>
              </Panel>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentSession: state.get('currentSession'),
    sessions: state.get('sessions')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    actions: bindActionCreators(sessionsActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Login);
