# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-09-22 07:33
from __future__ import unicode_literals

import concurrency.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Metacategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('title', models.CharField(max_length=512, verbose_name='Metacategory|title')),
                ('label', models.CharField(max_length=512, verbose_name='Metacategory|label')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Metacategory|description')),
                ('color', models.CharField(max_length=18, verbose_name='Metacategory|color')),
                ('has_comment', models.BooleanField()),
                ('is_default', models.BooleanField()),
                ('app', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='MetacategoryRevision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('version', concurrency.fields.AutoIncVersionField(default=1, help_text='record revision number', verbose_name='Model|version')),
                ('title', models.CharField(max_length=512, verbose_name='Metacategory|title')),
                ('label', models.CharField(max_length=512, verbose_name='Metacategory|label')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Metacategory|description')),
                ('color', models.CharField(max_length=18, verbose_name='Metacategory|color')),
                ('has_comment', models.BooleanField()),
                ('base', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='revisions', to='protocols.Metacategory', verbose_name='MetacategoryRevision|base')),
            ],
            options={
                'ordering': ['-version'],
            },
        ),
        migrations.CreateModel(
            name='Protocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('owner', models.CharField(max_length=512, verbose_name='Protocol|owner')),
                ('app', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProtocolRevision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('version', concurrency.fields.AutoIncVersionField(default=1, help_text='record revision number', verbose_name='Model|version')),
                ('title', models.CharField(blank=True, max_length=512, null=True, verbose_name='ProtocolRevision|title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='ProtocolRevision|description')),
                ('metacategories', models.ManyToManyField(related_name='protocols', to='protocols.MetacategoryRevision')),
                ('protocol', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='revisions', to='protocols.Protocol', verbose_name='ProtocolRevision|protocol')),
            ],
            options={
                'ordering': ['-version'],
            },
        ),
    ]
