import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Immutable from 'immutable';
import Modal  from 'react-modal';
import Note from './Note';
import './NoteList.css';

class NotesList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      editingNote: null,
      noteToDelete: null,
      modalIsOpen: false,
    };
  }

  componentWillMount() {
    Modal.setAppElement('body');
}

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  enterEditMode = (note) => {
    this.setState({ editingNote: note });
  }

  closeNote = () => {
    this.setState({ editingNote: null });
  }

  confirmDelete = (note) => {
    this.setState({
      modalIsOpen: true,
      noteToDelete: note
    })
  }

  deleteNote = () => {
    const { noteToDelete } = this.state;
    this.props.deleteNote(noteToDelete);
    this.closeModal();
  }

  closeModal = () => {
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    })
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    });
  }


  updateNote = (note, data) => {
    this.props.updateNote(note, data);
  }

  render() {
    if (this.props.notes.size === 0) {
      return (
        <div className="alert alert-warning">Commencez votre première note en écrivant dans le champ texte ci-dessous</div>
      );
    }

    return (
      <div>

        {this.props.notes.map((note) =>
          <Note
            note={ note }
            key={ note._id }
            onClick={ this.enterEditMode.bind(this, note) }
            onClose={ this.closeNote }
            onDelete={ this.confirmDelete.bind(this, note) }
            onSave={ this.updateNote }
            isEditing={ this.state.editingNote && note === this.state.editingNote }
            annotationCategories={this.props.annotationCategories} />
        )}

        <Modal
        className="Modal__Bootstrap modal-dialog"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div id="delete-note-modal" className="modal-content text-center">
            <button type="button" id="delete-note-close-modal-button" className="btn btn-secondary float-right" onClick={ this.handleModalCloseRequest }><span className="material-icons">close</span></button>
            <span className="modal-text">Êtes-vous sûr(e) de vouloir supprimer cette note ?</span>
            <div className="modal-footer">
              <button type="button" className="btn btn-primary text-secondary" id="delete-note-modal-button" onClick={ this.deleteNote }>Confirmer</button>
            </div>
          </div>
        </Modal>

      </div>
    );
  }
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
