import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import './Register.css';
// import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Register extends Component {

  register = () => {
    const username = this.username.value;
    const email = this.email.value;
    const password1 = this.password1.value;
    const password2 = this.password2.value;

    this.props.authActions.registerSubmit(username, email, password1, password2);
  }

  submit = (e) => {
    e.preventDefault();

    this.register();
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && errorMessages.has(fieldname)) {
      return errorMessages.get(fieldname).map((message, key) =>
        <p className="form-text" key={ key }>{ message }</p>
      );
    }
  }

  render() {

    // const errorMessages = this.props.register.get('errorMessages');

    return (
      <div>
        {/* <Navbar history={this.props.history} /> */}
        <div className="container-fluid">
          <div className="row">
            <div className="col-lg-6 offset-md-3">
              <div className="panel-login panel panel-default">
                <div className="card-header bg-secondary border-0">
                  <h4 className="text-center card-title">IRI Notes</h4>
                  <form onSubmit={this.submit}>
                    <div className="form-group" /*validationState={ errorMessages && errorMessages.has('username') ? 'error' : null }*/>
                      <label className="col-form-label text-primary">Nom d'utilisateur</label>
                      <input className="form-control bg-danger text-muted" type="text" /*inputRef={ref => { this.username = ref; }}*/ />
                      {/* { this.renderErrorMessage(errorMessages, 'username') } */}
                    </div>
                    <div className="form-group" /*validationState={ errorMessages && errorMessages.has('email') ? 'error' : null }*/>
                      <label className="col-form-label text-primary">Email</label>
                      <input className="form-control bg-danger text-muted" type="email" /*inputRef={ref => { this.email = ref; }}*/ />
                      {/* { this.renderErrorMessage(errorMessages, 'email') } */}
                    </div>
                    <div className="form-group" /*validationState={ errorMessages && errorMessages.has('password1') ? 'error' : null }*/>
                      <label className="col-form-label text-primary">Mot de passe</label>
                      <input className="form-control bg-danger text-muted" type="password" /*inputRef={ref => { this.password1 = ref; }}*/ />
                      {/* { this.renderErrorMessage(errorMessages, 'password1') } */}
                    </div>
                    <div className="form-group" /*validationState={ errorMessages && errorMessages.has('password2') ? 'error' : null }*/>
                      <label className="col-form-label text-primary">Confirmer le mot de passe</label>
                      <input className="form-control bg-danger text-muted" type="password" /*inputRef={ref => { this.password2 = ref; }}*/ />
                      {/* { this.renderErrorMessage(errorMessages, 'password2') } */}
                    </div>
                    <button type="submit" onClick={this.submit} className="btn btn-primary btn-lg text-secondary">S'inscrire</button>
                  </form>
                </div>
              </div>
              <p className="text-center">
                <a className="text-muted" href="/login" onClick={ this.onClickLogin }>Déjà inscrit ? Se connecter.</a>
              </p>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    register: state.get('register')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Register);
