import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Immutable from 'immutable';
import Modal  from 'react-modal';
import Note from './Note';

class NotesList extends Component {
  constructor(props) {
    super(props);
    this.state = {
    editingNote: null,
    noteToDelete: null,
    modalIsOpen: false,
    };
  }

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  enterEditMode = (note) => {
    this.setState({ editingNote: note });
  }

  closeNote = () => {
    this.setState({ editingNote: null });
  }

  confirmDelete = (note) => {
    this.setState({
      modalIsOpen: true,
      noteToDelete: note
    })
  }

  deleteNote = () => {
    const { noteToDelete } = this.state;
    this.props.deleteNote(noteToDelete);
    this.closeModal();
  }

  closeModal = () => {
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    })
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({
      modalIsOpen: false,
      noteToDelete: null
    });
  }


  updateNote = (note, data) => {
    this.props.updateNote(note, data);
  }

  render() {
    if (this.props.notes.size === 0) {
      return (
        <div className="alert alert-warning">Commencez votre première note en écrivant dans le champ texte ci-dessous</div>
      );
    }

    return (
      <div>

        {this.props.notes.map((note) =>
          <Note
            note={ note }
            key={ note._id }
            onClick={ this.enterEditMode.bind(this, note) }
            onClose={ this.closeNote }
            onDelete={ this.confirmDelete.bind(this, note) }
            onSave={ this.updateNote }
            isEditing={ this.state.editingNote && note === this.state.editingNote }
            annotationCategories={this.props.annotationCategories} />
        )}

        <Modal
        className="Modal__Bootstrap modal-dialog"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div className="modal-content">
            <div className="modal-body">
              Êtes vous sûr(e) ?
            </div>
            <div className="modal-footer">
              <button type="submit" className="btn btn-primary btn-lg" onClick={ this.deleteNote }>Confirmer</button>
              <button type="submit" className="btn btn-default btn-lg" onClick={ this.handleModalCloseRequest }>Fermer</button>
            </div>
          </div>
        </Modal>

      </div>
    );
  }
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
